﻿using System.Collections.Generic;
using System.Linq;

namespace Hearthstone_Deck_Tracker.Hearthstone.RelatedCardsSystem.Cards.Warlock;

public class Archimonde: ICardWithRelatedCards
{
	public string GetCardId() => HearthDb.CardIds.Collectible.Warlock.Archimonde;

	public bool ShouldShowForOpponent(Player opponent)
	{
		var card = Database.GetCardFromId(GetCardId());
		return CardUtils.MayCardBeRelevant(card, Core.Game.CurrentFormat, opponent.Class) && GetRelatedCards(opponent).Count > 1;
	}

	public List<Card?> GetRelatedCards(Player player) =>
		player.CardsPlayedThisMatch
			.Where(entity => entity.Info.Created)
			.Select(entity => CardUtils.GetProcessedCardFromCardId(entity.CardId, player))
			.Distinct()
			.Where(card => card is not null && card.IsDemon())
			.OrderByDescending(card => card!.Cost)
			.ToList();
}
